# Mock.js 的安装与使用

 <div style="color: pink;font-size:22px;font-weight:700">小常识：</div>
<br>
安装

我们可以看到官网上提供了很多关于不同前端项目的安装（有兴趣的同学可以看一下，`如果你和博主一样想在Vue项目中去使用的话那么就跳过下面这张图片我们看下面步骤`）
<br>


![在这里插入图片描述](https://img-blog.csdnimg.cn/92e563fbe17147deb3377fba81627546.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)

<br>
**下面就以Vue为例子来为大家演示**
<br>

1、创建vue项目
<br>
我们利用vue脚手架创建一个项目，不会访问这篇文章[https://blog.csdn.net/JHXL_/article/details/107631123](https://blog.csdn.net/JHXL_/article/details/107631123)
![在这里插入图片描述](https://img-blog.csdnimg.cn/02259bc6a0b24ca886ff98fccd70eedb.png)
<br>
2、项目中安装mock.js和axios
<br>
因为我们的mock是拦截请求，所以我们需要安装axios进行请求，当然使用原生的ajax也是可以的！

```php
npm i mockjs -D
npm i axios
```
<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/7b2d52012005485894a3dfeec8f80ff7.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
<br>

**使用**
<br>


**1、创建mock文件**

- 在src文件夹下面创建mock文件夹
- 在mock文件夹中创建json文件夹
- 在mock文件夹中创建index.js文件

<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/b347849d3c9641419c77a1304d44c172.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)

<br>

<br>
**2、在mock下面的index.js中引入mock并创建mock响应内容**

<br>

```php
// 引入 mock.js
const Mock = require('mockjs')
//Mock.mock  接口，请求方式，返回数据（数据就是json文件夹中的文件自行添加）
Mock.mock('/user/list', 'get', require('./json/userList'))
```
**说明：**`Mock.mock()`
此方法就是匹配我们的请求进行拦截然后返回模拟数据，有如下几种形式

```php
Mock.mock( rurl, template )
```

记录数据模板。当拦截到匹配 rurl 的 Ajax 请求时，将根据数据模板 template 生成模拟数据，并作为响应数据返回。

```php
Mock.mock( rurl, function( options ) )
```

记录用于生成响应数据的函数。当拦截到匹配 rurl 的 Ajax 请求时，函数 `function(options)` 将被执行，并把执行结果作为响应数据返回。

```php
Mock.mock( rurl, rtype, template )
```

记录数据模板。当拦截到匹配 rurl 和 rtype 的 Ajax 请求时，将根据数据模板 template 生成模拟数据，并作为响应数据返回。
<br>

```php
Mock.mock( rurl, rtype, function( options ) )
```

记录用于生成响应数据的函数。当拦截到匹配 rurl 和 rtype 的 Ajax 请求时，函数 function(options) 将被执行，并把执行结果作为响应数据返回。

当然我们的Mock还有好几种方法，更多方法可以去官网了解一下哦！

<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/c4fc6fc979484144a44e1724b3ffa2c2.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_11,color_FFFFFF,t_70,g_se,x_16)

<br>

**3、我们在mock文件夹下面的json文件夹下创建我们引用的userList.json**

<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/85b88c060126450fb5f04551abff0120.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)

<br>

```php
{
    "status": 0,
    "data|10": [
        {
            "id|+1": 1001,
            "company": "10001",
            "username": "ceshi1",
            "age": 25
        }
    ],
    "msg": ""
}
```
<br>

**4、接着我们就去我们的页面中测试请求**
<br>
找到我们页面，因为我们是新建的项目 所以我们删除页面中的东西 换成清爽的内容
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/fa61e879aead49618b0e413a69679fe5.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/0905d947e9fd4848b841a126a82bb1be.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
<br>
然后我们引入axios并注册事件就可以发送请求了

```php
<template>
  <div>
      <div @click="btnClick" class="btn">
          这是测试
      </div>
  </div>
</template>

<script>
import axios from "axios";

export default {
  data() {
    return {};
  },

  methods: {
    async btnClick() {
      const res = await axios.get("/user/list");
      console.log(res.data.data);
    },
  },
};
</script>

<style>
</style>
```

然后我们点击发现还是请求了接口这是为什么呢？原来是我们前面少了一个步骤，那就是我们需要在main中去引用我们的mock
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/6a3c3222810341c5b5d3c622ddd55ee5.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
<br>
再次尝试成功
<br>
![在这里插入图片描述](https://img-blog.csdnimg.cn/497963fb0e7a4c218b6cbfcacab98884.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5Yeg5L2V5b-D5YeJ,size_20,color_FFFFFF,t_70,g_se,x_16)
<br>
**总结**
<br>
通过上面的使用可以看到，我们前端发送的请求只要被我们的 Mock.mock 方法中的url匹配上就会被mock拦截，我们可以自行验证当我们使用mock并匹配上url后我们的network中是没有请求了，mock会根据我们定义的此条url的法则去返回对应的数据，在实际开发中其实前端很多后期工作都是在调试通接口后根据返回的数据进行的，通过mock我们前端就不会过多的依赖后端接口，只要知道后端返回数据的格式我们自己就可以通过mock.js自己生成数据进行模拟接口，从而在接口调通前我们也可以自己进行数据渲染和调试工作；

<br>

 <div style="color: #8E7CC3;font-size:22px;font-weight:700">小测试：</div>

根据上方小常识，判断下面描述错误得是？<br/><br/>

## 答案


```php
Mock.mock( rtype, template )
```

记录数据模板。当拦截到匹配 rtype 的 Ajax 请求类型时，将根据数据模板 template 生成模拟数据，并作为响应数据返回。


## 选项

### A


```php
Mock.mock( rurl, template )
```

记录数据模板。当拦截到匹配 rurl 的 Ajax 请求时，将根据数据模板 template 生成模拟数据，并作为响应数据返回。

### B

```php
Mock.mock( rurl, rtype, function( options ) )
```

记录用于生成响应数据的函数。当拦截到匹配 rurl 和 rtype 的 Ajax 请求时，函数 function(options) 将被执行，并把执行结果作为响应数据返回。

### C

```php
Mock.mock( rurl, rtype, template )
```

记录数据模板。当拦截到匹配 rurl 和 rtype 的 Ajax 请求时，将根据数据模板 template 生成模拟数据，并作为响应数据返回。



